cls
clear
set scheme s1color
graph set window fontface "Arial Narrow"
cd "/Users/alessandroruggieri/Downloads/monopsony-occupational-choice/model/RR_2025/robustness_xi/counter_out"
***************************************************************** 
* COMPARE GDP
preserve
tempfile master // Generate temporary save file to store data in
save `master', replace empty

* LOAD MODEL
import delimited "moments_baseline_xi_NET.csv", clear
sum value if var=="LSE"
gen eps=r(mean)
gen baseline=1
append using `master'
save `master', replace


import delimited "moments_counter_xi_GRE.csv", clear
sum value if var=="LSE"
gen eps=r(mean)
gen baseline=0
append using `master'
save `master', replace


local epsi "0_6 0_7 0_8 0_9 1_0 1_1 1_2 1_3 1_4 1_5 1_6 1_7 1_8 1_9 2_0 2_1 2_2 2_3 2_5 2_6 2_7 2_8 3_0 3_1 3_2 3_3 3_5 3_7 3_8 3_9 4_0 4_1 4_2 4_3 4_4 4_5"

foreach x of local epsi {
import delimited "moments_counterfactual_xi_eps_`x'.csv", clear
sum value if var=="LSE"
gen eps=r(mean)
gen baseline=0
append using `master'
save `master', replace
}


* MODEL vs DATA GDP
keep if var=="Log GDPpc"
gen  model_md = 1+1/eps
save `master', replace


* LOAD DATA
import delimited "/Users/alessandroruggieri/Downloads/monopsony-occupational-choice/model/RR_2025/robustness_xi/median_markdown_gdp.csv", clear
gen var="Log GDPpc"
rename md  data_md

rename gdpxc data_gdpxc
gen data_loggdpxc=log(data_gdpxc)

append using `master'
save `master', replace




* Construct model GDP
rename value model_loggdpxc
gen model_gdpxc=exp(model_loggdpxc)
sum model_gdpxc if baseline==1
gen Emodel_gdpxc=r(mean)
gen model_delta=model_gdpxc/Emodel_gdpxc
gen model_gdpxc_USD = model_delta*54000
gen model_loggdpxc_USD=log(model_gdpxc_USD)

* FIGURE ON GDP - MODEL VS DATA
sum model_loggdpxc_USD, d
local sd_model : di %4.3f r(sd)
sum data_loggdpxc, d
local sd_data : di %4.3f r(sd)

tw (scatter data_md data_gdpxc, mcolor(edkblue))  (scatter model_md model_gdpxc_USD, mcolor(maroon)) (lfit data_md data_gdpxc, lcolor(black)), ylabel(0.5(0.5)3.5) xlabel(20000(20000)80000) legend(order(1 "Data" 2 "Model")) xtitle("GDP (2017 USD)",size(*1.5)) ytitle("Median Markdown",size(*1.5))   graphregion(color(white)) bgcolor(white) caption("St.Dev.:  `sd_data' (Data), `sd_model' (Model)", color(maroon) position(150 0) size(*1.5))
gr export "counter_gdp_xi_model_vs_data.eps", replace
gr export "counter_gdp_xi_model_vs_data.png", replace

* REGRESSION
sum data_loggdpxc model_loggdpxc_USD



 
