#= 
----------------------------------------------------------------------------
Model solution.
Entry point.
----------------------------------------------------------------------------
Tristany Armangué-Jubert, Nov 2023
----------------------------------------------------------------------------
=#

### DEPENDENCIES
include("model_functions_utility.jl")
using Parameters, TickTock

# Start timer 
# tick()

# Random seed for replicability
Random.seed!(8)

# Settings 
N_a = 10

# Parametrization 
@with_kw mutable struct Params 
    # Elasticity of the labor supply
    ϵᴸ::Float64 = 3.31785 
    # TFP 
    A::Float64 = 1.0
    # Mass of agents (irrelevant and deprecated)
    Λ::Float64 = 1.0
    # Discount rate 
    β::Float64 = 0.961
    # Death probability
    δ::Float64 = 0.025
    # Revenue elastcity
    xi::Float64 = 0.3332
    # Gumbel shape 
    ν::Float64 = 1.0
    # Mean of productivity
    μ_z::Float64 = 0.0
    # Mean of amenities 
    μ_a::Float64 = 0.0
    
    # Entry cost (entrepreneurship)
    c::Float64 = 1.0
    # Investment cost (HC)
    c_z::Float64 = 1.0
    # Probability of moving up the HC ladder (base) 
    p_n::Float64 = 0.5
    # Probability of moving up the HC ladder (invest)
    p_i::Float64 = 0.55
    # Variance of prod 
    σ_z::Float64 = 0.5
    # Variance of amenities 
    σ_a::Float64 = 0.2
    # Correlation of prod and amenities 
    σ_za::Float64 = 0.0
end

# Pass to struct for initial guess
par = Params()

# Model estimation - Entire economy Netherlands
#targets = [34.7085025419236, 0.299382567405701, 28.9325332641602, 0.993987679481506, 0.519635558128357, 1.32045074462891]

# Initial guess - Entire economy Netherlands
#x0 = [6.59, 92.75, 0.72, 0.5, 2.24, 1.05]

# Model estimation - Manufacturing sector Netherlands
targets = [59.0222335368171, 0.406902819871902, 30.1278896331787, 0.988350570201874, 0.41840648651123, 1.52645233154297]

# Initial guess - Manufacturing sector Netherlands
x0 = [22.80033798033668, 122.43496994653235, 0.6487165361300524, 0.4988029334027742, 2.133578605916448, 0.8985415338196]

# Estimate parameters 
#estimate(par, 0.3, N_a, targets, x0)
#estimate_2(par, 0.3, N_a, targets, x0)

# Evaluate parameters at the baseline
evaluate(x0, par, N_a, 0.3, targets)

# # Simulate Netherlands baseline 
#counterfactual(x0, par, N_a, 0.3, targets, 3.31785, "baseline_NET", 1e-6, false, false)

# # Simulate Greece counterfactual 
#counterfactual(x0, par, N_a, 0.3, targets, 0.61554835, "counter_GRE", 1e-6, false, false)


# #Generic Counterfactual
for eps = 0.5:0.1:4.1
   display(eps)
    ext = "counterfactual_utility_eps_" * replace(string(eps), "."=>"_")
    counterfactual(x0, par, N_a, 0.3, targets, eps, ext, 1e-6, false, false)
end




