#= 
----------------------------------------------------------------------------
Model solution.
Entry point.
----------------------------------------------------------------------------
Tristany Armangué-Jubert, Nov 2023
----------------------------------------------------------------------------
=#

### DEPENDENCIES
include("model_functions_moments.jl")
using Parameters, TickTock

# Start timer 
# tick()

# Random seed for replicability
Random.seed!(8)

# Settings 
N_a = 10

# Parametrization 
@with_kw mutable struct Params 
    # Elasticity of the labor supply
    ϵᴸ::Float64 = 3.31785 
    # Entry cost (entrepreneurship)
    c::Float64 = 1.0
    # Investment cost (HC)
    c_z::Float64 = 1.0
    # Probability of moving up the HC ladder (base) 
    p_n::Float64 = 0.5
    # Probability of moving up the HC ladder (invest)
    p_i::Float64 = 0.55
    # TFP 
    A::Float64 = 1.0
    # Mass of agents (irrelevant and deprecated)
    Λ::Float64 = 1.0
    # Discount rate 
    β::Float64 = 0.961
    # Death probability
    δ::Float64 = 0.025
    # Revenue elastcity
    xi::Float64 = 0.3332
    # Gumbel shape 
    ν::Float64 = 1.0
    # Mean of productivity
    μ_z::Float64 = 0.0
    # Mean of amenities 
    μ_a::Float64 = 0.0
    # Variance of prod 
    σ_z::Float64 = 0.5
    # Variance of amenities 
    σ_a::Float64 = 0.2
    # Correlation of prod and amenities 
    σ_za::Float64 = 0.0
end

# Pass to struct for initial guess
par = Params()

# Model estimation - Entire economy Netherlands
#targets = [34.7085025419236, 0.299382567405701, 28.9325332641602, 0.993987679481506, 0.519635558128357, 1.32045074462891]

# Initial guess - Entire economy Netherlands
#x0 = [6.59, 92.75, 0.72, 0.5, 2.24, 1.05]

# Model estimation - Manufacturing sector Netherlands
# V.1
# Average firm size obtained by fitting a pareto mean to the sample average with a truncation at 5
# Dispersion in log firm size is obtained by using the pareto scale and ackowleding that a log Pareto is an exponential with a rate equal to the inverse of the Pareto scale squared
#targets = [11.8044, 0.406902819871902, 30.1278896331787, 0.915, 0.41840648651123, 1.52645233154297]

# V.2
# Average firm size obtained by fitting a pareto mean to the sample average with a truncation at 5
# Dispersion in log firm size is obtained by using the pareto scale and ackowleding that a log Pareto is an exponential with a rate equal to the inverse of the Pareto scale squared
# Overall share of investors obtained by computing the share of firms with more than 5 employees times the conditional share of investors, under the assumption that firms with less than 5 employees do not invest
targets = [11.8044, 0.0701, 30.1278896331787, 0.915, 0.41840648651123, 1.52645233154297]


# Initial guess - Manufacturing sector Netherlands
#x0 = [5.530250208555014, 81.79441316732381, 0.6211416080539056, 0.5387073885745084, 2.029218823060831, 0.8282505396116115]
#x0 = [5.515876169983113, 81.2384159722814, 0.6174942409344155, 0.5383959119916406, 2.023695574588631, 0.8454759428350516]
#x0 = [5.515876169983113, 98.2384159722814, 0.6374942409344155, 0.5383959119916406, 2.023695574588631, 0.8454759428350516]
x0 = [5.477806507992176, 98.34270148104449, 0.639017104098881, 0.5421117991229956, 2.012257447609706, 0.8378218117701739]

# Estimate parameters 
#estimate_v1(par, 0.3, N_a, targets,  x0)
#estimate_2_v1(par, 0.3, N_a, targets, x0)

# Evaluate parameters at the baseline
#evaluate_v1(x0, par, N_a, 0.3, v, targets)


# Estimate parameters 
#estimate_v2(par, 0.3, N_a, targets,  x0)
#estimate_2_v2(par, 0.3, N_a, targets, x0)
# Evaluate parameters at the baseline
#evaluate_v2(x0, par, N_a, 0.3, targets)


# # Simulate Netherlands baseline 
# counterfactual(x0, par, N_a, 0.3, targets, 3.31785, "baseline_moments_NET", 1e-6, false, false)

# # Simulate Greece counterfactual 
# counterfactual(x0, par, N_a, 0.3, targets, 0.61554835, "counter_moments_GRE", 1e-6, false, false)


# #Generic Counterfactual
 for eps = 1.45:+0.1:1.55
    display(eps)
     ext = "counterfactual_moments_eps_" * replace(string(eps), "."=>"_")
     counterfactual(x0, par, N_a, 0.3, targets, eps, ext, 1e-6, false, false)
 end




