cls
clear
set scheme s1color
graph set window fontface "Arial Narrow"

cd "/Users/alessandroruggieri/Downloads/monopsony-occupational-choice/model/RR_2025/main/estim_out/"

****** JACOBIAN MATRIX
tempfile master // Generate temporary save file to store data in
save `master', replace empty


import delimited "bestfit.csv", clear
rename value fit_best
drop if var=="loss"
sort var
save `master', replace


local num "1 2 3 4 5 6 "
foreach x of local num {
import delimited "jacobian`x'_0_975.csv", clear
rename value fit_par`x'
drop if var=="loss"
sort var
merge var using `master'
drop _merge
sort var
save `master', replace
}


local num "1 2 3 4 5 6"
foreach x of local num {
gen delta_par`x' = (fit_best-fit_par`x')/0.025
}


keep var delta_*
replace var = "1_E_l1" if var=="mean_firm_size"
replace var = "2_E_r_d" if var=="share_entrep_invest"
replace var = "3_E_age" if var=="mean_firm_age"
replace var = "4_sd_log_l1" if var=="std_log_firm_size"
replace var = "5_sd_log_w" if var=="std_log_wage"
replace var = "6_E_Delta_l" if var=="mean_empl_gro"
rename var moments
sort moments


export excel moments delta_par1 delta_par2 delta_par3 delta_par4 delta_par5 delta_par6 using "jacobian_NET.xlsx", replace first(var)



****** VECTOR OF DERIVATIVES OF MOMENTS WITH RESPECT TO ELAS
cls
clear

tempfile master // Generate temporary save file to store data in
save `master', replace empty

import delimited "bestfit.csv", clear
rename value fit_best
drop if var=="loss"
sort var
save `master', replace


import delimited "jacobianxi_0_975.csv", clear
rename value fit_parxi
drop if var=="loss"
sort var
merge var using `master'
drop _merge
sort var
save `master', replace


gen delta_parxi = (fit_best-fit_parxi)/0.025
keep var delta_*

rename var moments
sort moments

export excel moments delta_parxi using "jacobianxi_NET.xlsx", replace first(var)





