cls
clear
set scheme s1color
graph set window fontface "Arial Narrow"


cd "/Users/alessandroruggieri/Downloads/monopsony-occupational-choice/model/RR_2025/estim_out"

tempfile master // Generate temporary save file to store data in
save `master', replace empty



import delimited "bestfit.csv", clear
gen str sigma_z_string="."
replace sigma_z_string="2.133578605916448"
gen str fitt="Best"
append using `master'
save `master', replace

local epsi "0_7 0_8 0_9 1_0 1_1 1_2 1_3 1_4 1_5 1_6 1_7 1_8  2_1 2_2 2_3 2_4 2_5 2_6 2_7 2_8 2_9 3_0"
foreach x of local epsi {
import delimited "fit_sigmaz_`x'.csv", clear
gen str sigma_z_string=" "
replace sigma_z_string="`x'"
append using `master'
save `master', replace
}

replace sigma_z_string = subinstr(sigma_z_string, "_", ".", .)
destring sigma_z, gen(sigma_z)


preserve
keep  if var=="loss"
sum value if fitt=="Best"
gen bestvalue=r(mean)
sort sigma_z
tw (line value sigma_z if var=="loss", lcolor(edkblue) lw(thick)) (scatter value sigma_z if var=="loss" & fitt=="Best", mcolor(edkblue) msize(16pt)) (line bestvalue sigma_z if var=="loss", lcolor(maroon) lw(thick) lp(dash)) , xlabel(0.7(0.46)3.0) ylabel(0.0(1)4.0)  legend(off) xtitle("{&sigma}[z]",size(*1.5)) ytitle("Estimation loss",size(*1.5))
gr export "fit_sigmaz.eps", replace
gr export "fit_sigmaz.png", replace
restore




preserve
keep  if var=="std_log_firm_size"
sum value if fitt=="Best"
gen bestvalue=r(mean)
sort sigma_z
tw (line value sigma_z , lcolor(edkblue) lw(thick)) (scatter value sigma_z if fitt=="Best", mcolor(edkblue) msize(16pt)) (line bestvalue sigma_z, lcolor(maroon) lw(thick) lp(dash)), xlabel(0.7(0.46)3.0) ylabel(0.3(0.15)1.65) legend(off) xtitle("{&sigma}[z]",size(*1.5)) ytitle("std[ln L]",size(*1.5))
gr export "sensitivity_sigmaz.eps", replace
gr export "sensitivity_sigmaz.png", replace
restore




*****************************************************************************
gen Target =.
replace Target =0.988350570201874 if var=="std_log_firm_size"
replace Target =0.41840648651123  if var=="std_log_wage"
gen Deviation=.
replace Deviation=value-Target


sort var sigma_z
tw (line Deviation sigma_z if var=="std_log_firm_size", lcolor(edkblue) lw(thick) ) (line Deviation  sigma_z if var=="std_log_wage", lcolor(maroon) lw(thick)), legend(order(1 "std[ln L]" 2 "std[ln w]")) ytitle("Moment deviation from target",size(*1.5)) xtitle("{&sigma}[z]",size(*1.5)) ylabel(-0.75(0.25)1.0) xlabel(0.7(0.46)3.0)
gr export "contamination_sigmaz.eps", replace
gr export "contamination_sigmaz.png", replace






