cls
clear
set scheme s1color
graph set window fontface "Arial Narrow"


cd "/Users/alessandroruggieri/Downloads/monopsony-occupational-choice/model/RR_2025/main/estim_out"

tempfile master // Generate temporary save file to store data in
save `master', replace empty

import delimited "bestfit.csv", clear
gen str sigma_a_string="."
replace sigma_a_string="0.8985415338196"
gen str fitt="Best"
append using `master'
save `master', replace


local epsi "0_05 0_1 0_15 0_2 0_25 0_3 0_35 0_4 0_45 0_5 0_55 0_65 0_75 0_8 0_85 0_9 0_95 1_0 1_05 1_1 1_15 1_2 1_3 1_4"
foreach x of local epsi {
import delimited "fit_sigmaa_`x'.csv", clear
gen str sigma_a_string=" "
replace sigma_a_string="`x'"
append using `master'
save `master', replace
}

replace sigma_a_string = subinstr(sigma_a_string, "_", ".", .)
destring sigma_a, gen(sigma_a)

preserve
keep  if var=="loss"
sum value if fitt=="Best"
gen bestvalue=r(mean)
sort sigma_a
tw (line value sigma_a if var=="loss", lcolor(edkblue) lw(thick)) (scatter value sigma_a if var=="loss" & fitt=="Best", mcolor(edkblue) msize(16pt)) (line bestvalue sigma_a if var=="loss", lcolor(maroon) lw(thick) lp(dash)) , xlabel(0.1(0.25)1.4) ylabel(0.0(0.2)1.0)  legend(off) xtitle("{&sigma}[a]",size(*1.5)) ytitle("Estimation loss",size(*1.5))
gr export "fit_sigmaa.eps", replace
gr export "fit_sigmaa.png", replace
restore
 

preserve
keep  if var=="std_log_wage"
sum value if fitt=="Best"
gen bestvalue=r(mean)
sort sigma_a
tw (line value sigma_a , lcolor(edkblue) lw(thick)) (scatter value sigma_a if fitt=="Best", mcolor(edkblue) msize(16pt)) (line bestvalue sigma_a, lcolor(maroon) lw(thick) lp(dash)), xlabel(0.1(0.25)1.4) ylabel(0.3(0.15)0.75) legend(off) xtitle("{&sigma}[a]",size(*1.5)) ytitle("std[ln w]",size(*1.5))
gr export "sensitivity_sigmaa.eps", replace
gr export "sensitivity_sigmaa.png", replace
restore



*****************************************************************************
gen Target =.
replace Target=0.988350570201874 if var=="std_log_firm_size"
replace Target=0.41840648651123  if var=="std_log_wage"
gen Deviation=.
replace Deviation=value-Target

sort var sigma_a
tw (line Deviation sigma_a if var=="std_log_firm_size", lcolor(edkblue) lw(thick)) (line  Deviation  sigma_a if var=="std_log_wage", lcolor(maroon) lw(thick)), legend(order(1 "std[ln L]" 2 "std[ln w]")) ytitle("Moment deviation from target",size(*1.5)) xtitle("{&sigma}[a]",size(*1.5)) xlabel(0.1(0.25)1.4) ylabel(-0.1(0.05)0.35)
gr export "contamination_sigmaa.eps", replace
gr export "contamination_sigmaa.png", replace




