cls
clear
set scheme s1color
graph set window fontface "Arial Narrow"

cd "/Users/alessandroruggieri/Downloads/monopsony-occupational-choice/model/RR_2025/main/estim_out"

tempfile master // Generate temporary save file to store data in
save `master', replace empty



import delimited "bestfit.csv", clear
gen str pn_string="."
replace pn_string="0.4988029334027742"
gen str fitt="Best"
append using `master'
save `master', replace

*0_16 0_175 0_2 0_275 
local epsi "0_35 0_425 0_45 0_6 0_65 0_7 0_75 0_8 0_85 0_9 0_95" 
foreach x of local epsi {
import delimited "fit_pn_`x'.csv", clear
gen str pn_string=" "
replace pn_string="`x'"
append using `master'
save `master', replace
}

replace pn_string = subinstr(pn_string, "_", ".", .)
destring pn, gen(pn)


preserve
keep  if var=="loss"
sum value if fitt=="Best"
gen bestvalue=r(mean)
sort pn
tw (line value pn if var=="loss", lcolor(edkblue) lw(thick)) (scatter value pn if var=="loss" & fitt=="Best", mcolor(edkblue) msize(16pt)) (line bestvalue pn if var=="loss", lcolor(maroon) lw(thick) lp(dash)) , xlabel(0.35(0.2)0.95) ylabel(0.0(50)150)  legend(off) xtitle("p{subscript:n}",size(*1.5)) ytitle("Estimation loss",size(*1.5))
gr export "fit_pn.eps", replace
gr export "fit_pn.png", replace
restore


preserve
keep  if var=="mean_firm_age"
sum value if fitt=="Best"
gen bestvalue=r(mean)
sort pn
tw (line value pn , lcolor(edkblue) lw(thick)) (scatter value pn if fitt=="Best", mcolor(edkblue) msize(16pt)) (line bestvalue pn, lcolor(maroon) lw(thick) lp(dash)), xlabel(0.35(0.2)0.95) legend(off) xtitle("p{subscript:n}",size(*1.5))  ytitle("Average firm age",size(*1.5))
gr export "sensitivity_pn.eps", replace
gr export "sensitivity_pn.png", replace
restore



*****************************************************************************
preserve
replace value=value*100    if var=="mean_empl_gro" 
gen Target =.
replace Target =1.526*100  if var=="mean_empl_gro"
replace Target =30.13      if var=="mean_firm_age"
gen Deviation=.
replace Deviation=value-Target

sort var pn
tw (line Deviation pn if var=="mean_empl_gro", lcolor(edkblue) lw(thick) yaxis(1) ) (line Deviation pn if var=="mean_firm_age", lcolor(maroon) lw(thick) yaxis(2) ), legend(order(1 "Average cumulative firm growth (LHS)" 2 "Average firm age (RHS)")) ytitle("Moment deviation from target",size(*1.5) axis(1) )  ytitle("Moment deviation from target",size(*1.5) axis(2) ) xtitle("p{subscript:n}",size(*1.5)) xlabel(0.35(0.2)0.95) ylabel(-100(25)25, axis(1))
gr export "contamination_pn.eps", replace
gr export "contamination_pn.png", replace
restore

