cls
clear
set scheme s1color
graph set window fontface "Arial Narrow"

cd "/Users/alessandroruggieri/Downloads/monopsony-occupational-choice/model/RR_2025/main/estim_out"

tempfile master // Generate temporary save file to store data in
save `master', replace empty



import delimited "bestfit.csv", clear
gen str pi_string="."
replace pi_string="0.6487165361300524"
gen str fitt="Best"
append using `master'
save `master', replace


local epsi "0_525 0_55 0_6 0_625 0_65 0_675 0_7 0_75 0_8 0_85 0_9 0_925 0_95" 
foreach x of local epsi {
import delimited "fit_pi_`x'.csv", clear
gen str pi_string=" "
replace pi_string="`x'"
append using `master'
save `master', replace
}

replace pi_string = subinstr(pi_string, "_", ".", .)
destring pi, gen(pi)


preserve
keep  if var=="loss"
sum value if fitt=="Best"
gen bestvalue=r(mean)
sort pi
tw (line value pi if var=="loss", lcolor(edkblue) lw(thick)) (scatter value pi if var=="loss" & fitt=="Best", mcolor(edkblue) msize(16pt)) (line bestvalue pi if var=="loss", lcolor(maroon) lw(thick) lp(dash)) , xlabel(0.525(0.05)0.925) ylabel(0.0(0.2)1.2)  legend(off) xtitle("p{subscript:i}",size(*1.5)) ytitle("Estimation loss",size(*1.5))
gr export "fit_pi.eps", replace
gr export "fit_pi.png", replace
restore


preserve
keep  if var=="mean_empl_gro"
replace value=value*100
sum value if fitt=="Best"
gen bestvalue=r(mean)
sort pi
tw (line value pi , lcolor(edkblue) lw(thick)) (scatter value pi if fitt=="Best", mcolor(edkblue) msize(16pt)) (line bestvalue pi, lcolor(maroon) lw(thick) lp(dash)), xlabel(0.525(0.05)0.925) legend(off) xtitle("p{subscript:i}",size(*1.5)) ytitle("Cumulative firm size growth",size(*1.5))
gr export "sensitivity_pi.eps", replace
gr export "sensitivity_pi.png", replace
restore



*****************************************************************************
preserve
replace value=value*100    if var=="mean_empl_gro" 
gen Target =.
replace Target =1.526*100  if var=="mean_empl_gro"
replace Target =30.13      if var=="mean_firm_age"
gen Deviation=.
replace Deviation=value-Target

sort var pi
tw (line Deviation pi if var=="mean_empl_gro", lcolor(edkblue) lw(thick) yaxis(1) ) (line Deviation pi if var=="mean_firm_age", lcolor(maroon) lw(thick) yaxis(2) ), legend(order(1 "Average cumulative firm growth (LHS)" 2 "Average firm age (RHS)")) ytitle("Moment deviation from target",size(*1.5) axis(1) )  ytitle("Moment deviation from target",size(*1.5) axis(2) ) xtitle("p{subscript:i}",size(*1.5))  xlabel(0.525(0.05)0.925) ylabel(-60(20)20, axis(1)) ylabel(-60(20)20, axis(2))

gr export "contamination_pi.eps", replace
gr export "contamination_pi.png", replace
restore

