cls
clear
set scheme s1color
graph set window fontface "Arial Narrow"

cd "/Users/alessandroruggieri/Downloads/monopsony-occupational-choice/"


*** MODEL
import delimited "model/RR_2025/main/counter_out/moments_baseline_NET.csv"
keep if (var=="Share firms size<=20" ||  var=="Share firms size 21-100" ||  var=="Share firms size>100" ||  var=="Share firms age<=30" ||  var=="Share firms age 31-60" ||  var=="Share firms age>60" || var=="Share investors size<=20" || var=="Share investors size 21-100" || var=="Share investors size>100")
rename value value_model
sort var
save "model/RR_2025/main/counter_out/moments_baseline_NET_nontargeted.dta", replace


*** DATA
import excel "data/WBES/out/targets_NET.xlsx", sheet("Sheet1") firstrow clear
keep Eshare100plus Eshare20below Eshare_y30below Eshare_y60plus Eshare_rd_20below Eshare_rd_20_100 Eshare_rd_100plus
gen Eshare20_100= 1-Eshare20below-Eshare100plus
gen Eshare_y3060 = 1- Eshare_y30below - Eshare_y60plus
gen id=_n
reshape long Eshare, i(id) j(var) str
drop id
rename Eshare value_data
replace var="Share firms size<=20" if var=="20below"
replace var="Share firms size 21-100" if var=="20_100"
replace var="Share firms size>100" if var=="100plus"
replace var="Share firms age<=30" if var=="_y30below"
replace var="Share firms age 31-60" if var=="_y3060"
replace var="Share firms age>60" if var=="_y60plus"
replace var="Share investors size<=20"    if var=="_rd_20below"
replace var="Share investors size 21-100" if var=="_rd_20_100"
replace var="Share investors size>100"    if var=="_rd_100plus"


sort var
merge var using "model/RR_2025/main/counter_out/moments_baseline_NET_nontargeted.dta"


*** FIGURE NON-TARGETED MOMENTS
gen sizedist=0
replace sizedist=1 if var=="Share firms size<=20"
replace sizedist=1 if var=="Share firms size 21-100"
replace sizedist=1 if var=="Share firms size>100"

gen agedist=0
replace agedist=1 if var=="Share firms age<=30" 
replace agedist=1 if var=="Share firms age 31-60" 
replace agedist=1 if var=="Share firms age>60"


gen rd_sizedist=0
replace rd_sizedist=1 if var=="Share investors size<=20" 
replace rd_sizedist=1 if var=="Share investors size 21-100" 
replace rd_sizedist=1 if var=="Share investors size>100"



replace var="<=20 employees"   if var=="Share firms size<=20"  
replace var="21-100 employees" if var=="Share firms size 21-100"  
replace var=">100 employees"   if var=="Share firms size>100"  

replace var="<=30 y.o."        if var=="Share firms age<=30"  
replace var="31-60 y.o."       if var=="Share firms age 31-60" 
replace var=">60 y.o."         if var=="Share firms age>60" 

replace var="<=20 employees"   if var=="Share investors size<=20" 
replace var="21-100 employees" if var=="Share investors size 21-100" 
replace var=">100 employees"   if var=="Share investors size>100"



gr bar value_data value_mode if sizedist==1, over(var, sort(1) descending) legend(order(1 "Data" 2 " Model")) bar(1, color(edkblue)) bar(2, color(maroon))  
gr export "model/RR_2025/main/estim_out/sizedist_NET_nontargeted.eps", replace


gr bar value_data value_mode if agedist==1, over(var, sort(1) descending) legend(order(1 "Data" 2 " Model")) bar(1, color(edkblue)) bar(2, color(maroon))  
gr export "model/RR_2025/main/estim_out/agedist_NET_nontargeted.eps", replace


gr bar value_data value_mode if rd_sizedist==1, over(var, sort(1)) legend(order(1 "Data" 2 " Model")) bar(1, color(edkblue)) bar(2, color(maroon))  
gr export "model/RR_2025/main/estim_out/rd_sizedist_NET_nontargeted.eps", replace

