cls
clear
set scheme s1color
graph set window fontface "Arial Narrow"

cd "/Users/alessandroruggieri/Downloads/monopsony-occupational-choice/model/RR_2025/main/estim_out"

tempfile master // Generate temporary save file to store data in
save `master', replace empty



import delimited "bestfit.csv", clear
gen str cz_string="."
replace cz_string="122.43496994653235"
gen str fitt="Best"
append using `master'
save `master', replace

local epsi "70_0 80_0 90_0 95_0 100_0 105_0 110_0 115_0 120_0 130_0 135_0 140_0 145_0 150_0"
foreach x of local epsi {
import delimited "fit_cz_`x'.csv", clear
gen str cz_string=" "
replace cz_string="`x'"
append using `master'
save `master', replace
}

replace cz_string = subinstr(cz_string, "_", ".", .)
destring cz, gen(cz)


preserve
keep  if var=="loss"
sum value if fitt=="Best"
gen bestvalue=r(mean)
sort cz
tw (line value cz if var=="loss", lcolor(edkblue) lw(thick)) (scatter value cz if var=="loss" & fitt=="Best", mcolor(edkblue) msize(16pt)) (line bestvalue cz if var=="loss", lcolor(maroon) lw(thick) lp(dash)) , xlabel(70(10)150) ylabel(0.0(0.05)0.2)  legend(off) xtitle("c{subscript:z}",size(*1.5)) ytitle("Estimation loss",size(*1.5))
gr export "fit_cz.eps", replace
gr export "fit_cz.png", replace
restore



preserve
keep  if var=="share_entrep_invest"
sum value if fitt=="Best"
gen bestvalue=r(mean)
sort cz
tw (line value cz , lcolor(edkblue) lw(thick)) (scatter value cz if fitt=="Best", mcolor(edkblue) msize(16pt)) (line bestvalue cz, lcolor(maroon) lw(thick) lp(dash)) , xlabel(70(10)150) legend(off) xtitle("c{subscript:z}",size(*1.5)) ytitle("Share of firms investing",size(*1.5))
gr export "sensitivity_cz.eps", replace
gr export "sensitivity_cz.png", replace
restore

 
*****************************************************************************
preserve
gen Target =.
replace Target=59.02  if var=="mean_firm_size"
replace Target=0.407  if var=="share_entrep_invest"
gen Deviation=.
replace Deviation=value-Target

sort var cz
tw (line Deviation cz if var=="mean_firm_size", lcolor(edkblue) lw(thick) yaxis(1) ) (line  Deviation  cz if var=="share_entrep_invest", lcolor(maroon) lw(thick) yaxis(2) ), legend(order(1 "Average firm size (LHS)" 2 "Share of investors (RHS)")) ytitle("Moment deviation from target",size(*1.5) axis(1) ) ytitle("Moment deviation from target",size(*1.5) axis(2) ) xtitle("c{subscript:z}",size(*1.5))  xlabel(70(10)150) 
gr export "contamination_cz.eps", replace
gr export "contamination_cz.png", replace
restore


*ylabel(-0.1(0.05)0.35)




