cls
clear
set scheme s1color
graph set window fontface "Arial Narrow"

cd "/Users/alessandroruggieri/Downloads/monopsony-occupational-choice/model/RR_2025/main/estim_out"

tempfile master // Generate temporary save file to store data in
save `master', replace empty


import delimited "bestfit.csv", clear
gen str c_string="."
replace c_string="22.80033798033668"
gen str fitt="Best"
append using `master'
save `master', replace


local epsi "5 10 12 14 16 18 20 22 26 28 30 32 34 40 45 50"
foreach x of local epsi {
import delimited "fit_c_`x'_0.csv", clear
gen str c_string=" "
replace c_string="`x'"
append using `master'
save `master', replace
}

replace c_string = subinstr(c_string, "_", ".", .)
destring c, gen(c)

preserve
keep  if var=="loss"
sum value if fitt=="Best"
gen bestvalue=r(mean)
sort c
tw (line value c if var=="loss", lcolor(edkblue) lw(thick)) (scatter value c if var=="loss" & fitt=="Best", mcolor(edkblue) msize(16pt)) (line bestvalue c if var=="loss", lcolor(maroon) lw(thick) lp(dash)) , xlabel(5(5)50) ylabel(0.0(0.1)0.5)  legend(off) xtitle("c{subscript:f}",size(*1.5)) ytitle("Estimation loss",size(*1.5))
gr export "fit_cf.eps", replace
gr export "fit_cf.png", replace
restore


preserve
keep  if var=="mean_firm_size"
sum value if fitt=="Best"
gen bestvalue=r(mean)
sort c
tw (line value c , lcolor(edkblue) lw(thick)) (scatter value c if fitt=="Best", mcolor(edkblue) msize(16pt)) (line bestvalue c , lcolor(maroon) lw(thick) lp(dash)) , xlabel(5(5)50) legend(off) xtitle("c{subscript:f}",size(*1.5)) ytitle("Average firm size",size(*1.5))
gr export "sensitivity_cf.eps", replace
gr export "sensitivity_cf.png", replace
restore




*****************************************************************************
preserve
gen Target =.
replace Target=59.02  if var=="mean_firm_size"
replace Target=0.407  if var=="share_entrep_invest"
gen Deviation=.
replace Deviation=value-Target

sort var c
tw (line Deviation c if var=="mean_firm_size", lcolor(edkblue) lw(thick) yaxis(1) ) (line  Deviation  c if var=="share_entrep_invest", lcolor(maroon) lw(thick) yaxis(2)), legend(order(1 "Average firm size (LHS)" 2 "Share of investors (RHS)")) ytitle("Moment deviation from target",size(*1.5) axis(2) ) ytitle("Moment deviation from target",size(*1.5) axis(1) )  xtitle("c{subscript:f}",size(*1.5)) xlabel(5(5)50) 
gr export "contamination_cf.eps", replace
gr export "contamination_cf.png", replace
restore
