cls
clear
set scheme s1color
graph set window fontface "Arial Narrow"
cd "/Users/tristany/Desktop/Replication_AJRR/Model/main/counter_out/"

*** ENTREPRENEURSHIP POLICY
import delimited "entry_counter_GRE.csv", encoding(Big5) clear
gen prod=_n
reshape long v, i(prod) j(amenities)
rename v entry

twoway contour entry prod amenities, graphregion(fcolor(white) lcolor(white)) crule(linear) scolor(white) ecolor(maroon) clegend(off)  interp(shepard) ccuts(0(1)1) xtitle("Firm amenity, a",size(*1.5)) ytitle("Firm productivity, z",size(*1.5))  xla(1(3)9, labcolor(bg) tlength(0)) yla(, labcolor(bg) tlength(0)) minmax
gr export "entry_policy_counter_GRE.eps", replace
gr export "entry_policy_counter_GRE.png", replace


import delimited "entry_baseline_NET.csv", encoding(Big5) clear
gen prod=_n
reshape long v, i(prod) j(amenities)
rename v entry
twoway contour entry prod amenities, graphregion(fcolor(white) lcolor(white)) crule(linear) scolor(white) ecolor(maroon) clegend(off)  interp(shepard) ccuts(0(1)1) xtitle("Firm amenity, a",size(*1.5)) ytitle("Firm productivity, z",size(*1.5)) xla(1(3)9, labcolor(bg) tlength(0)) yla(, labcolor(bg) tlength(0)) minmax
gr export "entry_policy_baseline_NET.eps", replace
gr export "entry_policy_baseline_NET.png", replace



*** INVESTMENT POLICY
import delimited "investment_counter_GRE.csv", encoding(Big5) clear
gen prod=_n
reshape long v, i(prod) j(amenities)
rename v entry

twoway contour entry prod amenities, graphregion(fcolor(white) lcolor(white)) crule(linear) scolor(white) ecolor(maroon) clegend(off)  interp(shepard) ccuts(0(1)1) xtitle("Firm amenities, a",size(*1.5)) ytitle("Firm productivity, z",size(*1.5))  xla(1(3)9, labcolor(bg) tlength(0)) yla(, labcolor(bg) tlength(0)) minmax
gr export "inv_policy_counter_GRE.eps", replace
gr export "inv_policy_counter_GRE.png", replace


import delimited "investment_baseline_NET.csv", encoding(Big5) clear
gen prod=_n
reshape long v, i(prod) j(amenities)
rename v entry
twoway contour entry prod amenities, graphregion(fcolor(white) lcolor(white)) crule(linear) scolor(white) ecolor(maroon) clegend(off)  interp(shepard) ccuts(0(1)1) xtitle("Firm amenity, a",size(*1.5)) ytitle("Firm productivity, z",size(*1.5)) xla(1(3)9, labcolor(bg) tlength(0)) yla(, labcolor(bg) tlength(0)) minmax
gr export "inv_policy_baseline_NET.eps", replace
gr export "inv_policy_baseline_NET.png", replace



*** SHARES OF ENTREPRENEURS and INVESTORS by PRODUCTIVITY
tempfile master // Generate temporary save file to store data in
save `master', replace empty

import delimited "mean_profits_baseline_NET.csv", clear
keep prod share mean_inv
gen baseline=1
save `master', replace


import delimited "mean_profits_counter_GRE.csv", clear
keep prod share mean_inv
gen baseline=0
append using `master'
save `master', replace


gen log_prod=log(prod)
sum prod, d
gen max_prod=r(max)


tw (line share log_prod if baseline==1 & log_prod>=0  & prod<max_prod,  lw(thick) lcolor(edkblue)) (line share log_prod if baseline==0 & log_prod>=0  & prod<max_prod,  lw(thick) lcolor(maroon) lp(dash)), legend(order(1 "Baseline" 2 "Counterfactual"))  xtitle("Firm productivity (log)" ,size(*1.5) ) ytitle("Share",size(*1.5)) ylabel(0(0.25)1)
gr export "share_entry_byprod.eps", replace
gr export "share_entry_byprod.png", replace


tw (line mean_inv log_prod if baseline==1 & log_prod>=0 & prod<max_prod,  lw(thick) lcolor(edkblue)) (line mean_inv log_prod if baseline==0 & log_prod>=0 & prod<max_prod,  lw(thick) lcolor(maroon) lp(dash)), legend(order(1 "Baseline" 2 "Counterfactual"))  xtitle("Firm productivity (log)" ,size(*1.5) ) ytitle("Share",size(*1.5)) ylabel(0(0.25)1)
gr export "share_inv_byprod.eps", replace
gr export "share_inv_byprod.png", replace



*** SHARES OF ENTREPRENEURS and INVESTORS by AMENITIES

tempfile master // Generate temporary save file to store data in
save `master', replace empty

import delimited "mean_profits_amenities_baseline_NET.csv", clear
keep amenit share mean_inv
gen baseline=1
save `master', replace

import delimited "mean_profits_amenities_counter_GRE.csv", clear
keep amenit share mean_inv
gen baseline=0
append using `master'
save `master', replace


gen log_amenities=log(amenities)

tw (line share ame if baseline==1 ,  lw(thick) lcolor(edkblue)) (line share ame if baseline==0,  lw(thick) lcolor(maroon) lp(dash)), legend(order(1 "Baseline" 2 "Counterfactual"))  xtitle("Firm amenity" ,size(*1.5) ) ytitle("Share",size(*1.5)) ylabel(0.01(0.01)0.05)
gr export "share_entry_byamen.eps", replace
gr export "share_entry_byamen.png", replace


tw (line mean_inv ame if baseline==1,  lw(thick) lcolor(edkblue)) (line mean_inv ame if baseline==0,  lw(thick) lcolor(maroon) lp(dash)), legend(order(1 "Baseline" 2 "Counterfactual"))  xtitle("Firm amenity" ,size(*1.5) ) ytitle("Share",size(*1.5)) ylabel(0.00(0.005)0.02)
gr export "share_inv_byamen.eps", replace
gr export "share_inv_byamen.png", replace


