cls
clear
set scheme s1color
graph set window fontface "Arial Narrow"
cd "/Users/tristany/Desktop/Replication_AJRR/Model/main/counter_out/"



tempfile master // Generate temporary save file to store data in
save `master', replace empty


import delimited "moments_baseline_NET.csv", clear
sum value if var=="LSE"
gen eps=r(mean)
gen baseline=1
append using `master'
save `master', replace

import delimited "moments_counter_GRE.csv", clear
sum value if var=="LSE"
gen eps=r(mean)
gen baseline=0
append using `master'
save `master', replace


local epsi " 0_5 0_6 0_7 0_75 0_85 0_9 1_0 1_1 1_2 1_3 1_4 1_5 1_6 1_7 1_8 1_9 2_0 2_1 2_2 2_4 2_5 2_6 2_7 2_8 2_9 3_0 3_1 3_2 3_3 3_4 3_5 3_6 3_7 3_8 3_9 4_0 4_1 4_2 4_3 4_4 4_5 4_6 4_7 4_8  4_9 5_0 5_1 5_2  5_3 5_4 5_5"

 
foreach x of local epsi {
import delimited "moments_counterfactual_eps_`x'.csv", clear
sum value if var=="LSE"
gen eps=r(mean)
gen baseline=0
append using `master'
save `master', replace
}

* Construct markdown
gen md=1+1/eps


stop


* Firm size growth
replace value=value*100 if var=="Mean employment growth"
replace value=value*100 if var=="Mean employment growth x year"

* PANEL A
tw (scatter value md if baseline==0 & var=="Mean firm size", mcolor(edkblue) msize(large))  (scatter value md if baseline==1  & var=="Mean firm size", mcolor(maroon) msize(large)) , ytitle("Average firm size (# employees)",size(*1.5)) xtitle("Wage markdown",size(*1.5)) xlabel(1(0.7)3.1) ylabel(45(5)60)  legend(off)
gr export "counter_avg_firmsize.eps", replace
gr export "counter_avg_firmsize.png", replace

 
* PANEL B
tw (scatter value md if baseline==0 & var=="Mean employment growth", mcolor(edkblue) msize(large))  (scatter value md if baseline==1 & var=="Mean employment growth", mcolor(maroon) msize(large))  , ytitle("Average firm growth, %",size(*1.5)) xtitle("Wage markdown",size(*1.5)) xlabel(1(0.7)3.1) ylabel(25(25)175)  legend(off )
gr export "counter_avg_firmsize_growth.eps", replace
gr export "counter_avg_firmsize_growth.png", replace


* PANEL B alternative
tw (scatter value md if baseline==0 & var=="Mean employment growth x year", mcolor(edkblue) msize(large))  (scatter value md if baseline==1 & var=="Mean employment growth x year", mcolor(maroon) msize(large))  , ytitle("Average annualized firm growth rate, %",size(*1.5)) xtitle("Wage markdown",size(*1.5)) xlabel(1(0.7)3.1) ylabel(0(2.5)10)  legend(off )
gr export "counter_avg_firmsize_growth_xyear.eps", replace
gr export "counter_avg_firmsize_growth_xyear.png", replace



* PANEL D
tw (scatter value md if baseline==0 & var=="Share Entrepreneurs who Invest (cond.)" , mcolor(edkblue) msize(large))  (scatter value md if baseline==1 & var=="Share Entrepreneurs who Invest (cond.)" , mcolor(maroon) msize(large)) , ytitle("Firms performing r&d",size(*1.5)) xtitle("Wage markdown",size(*1.5)) xlabel(1(0.7)3.1) ylabel(0.20(0.05)0.45) legend(off)
gr export "counter_share_rd.eps", replace
gr export "counter_share_rd.png", replace


* PANEL D
sum value if baseline==1 & var=="Mean productivity"
gen Evalue=r(mean)
gen tfp=value/Evalue if var=="Mean productivity"

tw (scatter tfp md if baseline==0 & var=="Mean productivity" , mcolor(edkblue) msize(large))  (scatter tfp md if baseline==1 & var=="Mean productivity" , mcolor(maroon) msize(large)) , ytitle("Average firm productivity",size(*1.5)) xtitle("Wage markdown",size(*1.5)) xlabel(1(0.7)3.1) ylabel(0.7(0.1)1.1) legend(off)
gr export "counter_tfp.eps", replace
gr export "counter_tfp.png", replace



* PANEL E
tw (scatter value md if baseline==0  & var=="Mean log-wage", mcolor(edkblue) msize(large))  (scatter value md if baseline==1 & var=="Mean log-wage", mcolor(maroon) msize(large))  , ytitle("Average (log) wage",size(*1.5)) xtitle("Wage markdown",size(*1.5))  xlabel(1(0.5)3) legend(off)
gr export "counter_meanlogwage.eps", replace
gr export "counter_meanlogwage.png", replace

* PANEL F
tw (scatter value md if baseline==0  & var=="Std log-wage", mcolor(edkblue) msize(large))  (scatter value md if baseline==1 & var=="Std log-wage", mcolor(maroon) msize(large)), ytitle("St.Dev. (log) wage",size(*1.5)) xtitle("Wage markdown",size(*1.5))  xlabel(1(0.5)3) legend(off)
gr export "counter_sdlogwage.eps", replace
gr export "counter_sdlogwage.png", replace


* PANEL G
tw (scatter value md if baseline==0  & var=="Std log firm size", mcolor(edkblue) msize(large))  (scatter value md if baseline==1 & var=="Std log firm size", mcolor(maroon) msize(large)), ytitle("St.Dev. (log) firm size",size(*1.5)) xtitle("Wage markdown",size(*1.5))  xlabel(1(0.5)3) legend(off)
gr export "counter_sdlogfirmsize.eps", replace
gr export "counter_sdlogfirmsize.png", replace


* PANEL H
tw (scatter value md if baseline==0  & var=="Firm size wage premium", mcolor(edkblue) msize(large))  (scatter value md if baseline==1 & var=="Firm size wage premium", mcolor(maroon) msize(large)), ytitle("Firm size wage premium",size(*1.5)) xtitle("Wage markdown",size(*1.5))  xlabel(1(0.5)3) legend(off)
gr export "counter_sizewagepremium.eps", replace
gr export "counter_sizewagepremium.png", replace


* PANEL I
tw (scatter value md if baseline==0  & var=="Firm size RD premium", mcolor(edkblue) msize(large))  (scatter value md if baseline==1 & var=="Firm size RD premium", mcolor(maroon) msize(large)), ytitle("Firm R&D wage premium",size(*1.5)) xtitle("Wage markdown",size(*1.5))  xlabel(1(0.5)3) legend(off)
gr export "counter_rdwagepremium.eps", replace
gr export "counter_rdwagepremium.png", replace

 
 
 
