cls
clear
set scheme s1color
graph set window fontface "Arial Narrow"
cd "/Users/tristany/Desktop/Replication_AJRR/Model/main/counter_out"



tempfile master // Generate temporary save file to store data in
save `master', replace empty


import delimited "simul_l1_baseline_NET.csv", clear
rename value l1
gen baseline=1
gen id=_n
sort id
save `master', replace

import delimited "simul_a_baseline_NET.csv", clear
rename value a
gen baseline=1
gen id=_n
sort id
merge id using `master'
drop _merge
sort id
save `master', replace

import delimited "simul_z_baseline_NET.csv", clear
rename value z
gen baseline=1
gen id=_n
sort id
merge id using `master'
drop _merge
save `master', replace
save simul_NET.dta, replace


import delimited "simul_l1_counter_GRE.csv", clear
rename value l1
gen baseline=0
gen id=_n
sort id
save `master', replace


import delimited "simul_a_counter_GRE.csv", clear
rename value a
gen baseline=0
gen id=_n
sort id
merge id using `master'
drop _merge
sort id
save `master', replace

import delimited "simul_z_counter_GRE.csv", clear
rename value z
gen baseline=0
gen id=_n
sort id
merge id using `master'
drop _merge
save `master', replace
save simul_GRE.dta, replace
append using simul_NET.dta



gen apl=z*l1^(0.332-1)
sum apl if baseline==1, d
sum apl if baseline==0, d




gen log_z=log(z)
gen log_a=log(a)
gen log_apl=log(apl)
gen log_l1= log(l1)


  	   
tw (lpolyci log_apl log_z if baseline==1, nofit) ///
   (lpolyci log_apl log_z if baseline==0, nofit) ///
   (lpoly log_apl log_z if baseline==1,  lw(thick) lcolor(edkblue))  ///
   (lpoly log_apl log_z if baseline==0,  lw(thick) lcolor(maroon) lp(dash) ) ///
, xtitle("Firm productivity (log)",size(*1.5) ) ytitle("Average product of labor (log)",size(*1.5)) legend(order(2 "Baseline" 3 "Counterfactual" )) xlabel(0(1)5) ylabel(-2(1)3)
gr export "apl_z.eps", replace
gr export "apl_z.png", replace



tw (lpolyci log_apl a if baseline==0, nofit)  ///
   (lpolyci log_apl a if baseline==1, nofit)  ///
   (lpoly log_apl a if baseline==1,  lw(thick) lcolor(edkblue)) ///
   (lpoly log_apl a if baseline==0,  lw(thick) lcolor(maroon) lp(dash))  ///
, xtitle("Firm amenity" ,size(*1.5) ) ytitle("Average product of labor (log)",size(*1.5)) legend(order(2 "Baseline" 3 "Counterfactual" )) xlabel(0(1)6) ylabel(-2(1)3)
gr export "apl_a.eps", replace
gr export "apl_a.png", replace





tw (lfit log_apl l1 if baseline==1) ///
   (lfit log_apl l1 if baseline==0) ///
, xtitle("Firm size (log)",size(*1.5) ) ytitle("Average product of labor (log)",size(*1.5)) legend(order(1 "Baseline" 2 "Counterfactual" ))  ylabel(-2(1)3)


***************************************************************


