cls
clear
set scheme s1color
graph set window fontface "Arial Narrow"

* Directory
cd "/Users/tristany/Desktop/Replication_AJRR/Data/"

* Load Penn World table
use "dta/pwt1001.dta", clear

* Generate other TFP measures
gen tfp= rgdpna/( (avh*emp)^(2/3)*rnna^(1/3))
gen norm_tfp=.
foreach x of numlist 1950/2019{
sum tfp if country=="Netherlands" & year==`x', d
gen tfp_US=r(mean) if year==`x'
replace norm_tfp=tfp/tfp_US if year==`x'
drop tfp_US
}



* CLEAN
keep country countrycode year ctfp norm_tfp
replace country="Slovak Republic" if country=="Slovakia"

* SORT AND SAVE
sort country year
save "dta/tfp.dta", replace





* Load WBES data
use "dta/New_Comprehensive_March_1_2024.dta", clear

* Destring year
gen yr=substr(country,-4,.)
destring yr, gen(year)

* Extract country
ereplace country = sieve(country), omit(0123456789)

* Adjust string
replace country="Antigua and Barbuda" if country=="Antiguaandbarbuda"
replace country="Bahamas, The" if country=="Bahamas"
replace country="Burkina Faso" if country=="BurkinaFaso"
replace country="Cabo Verde" if country=="CapeVerde"
replace country="Congo, Dem. Rep." if country=="Congo"
replace country="Congo, Dem. Rep." if country=="DRC"
replace country="Costa Rica" if country=="Costarica"
replace country="Dominican Republic" if country=="DominicanRepublic"
replace country="Egypt, Arab Rep." if country=="Egypt"
replace country="Yemen, Rep." if country=="Yemen"
replace country="Turkiye" if country=="Türkiye"
replace country="Trinidad and Tobago" if country=="TrinidadandTobago"
replace country="South Africa" if country=="SouthAfrica"
replace country="Sri Lanka" if country=="SriLanka"
replace country="Russian Federation" if country=="Russia"
replace country="Papua New Guinea" if country=="PapuaNewGuinea"
replace country="Micronesia, Fed. Sts." if country=="Micronesia"
replace country="Cote d'Ivoire" if country=="Côte d'Ivoire"
replace country="Gambia, The" if country=="Gambia"
replace country="Guinea-Bissau" if country=="GuineaBissau"
replace country="Lao PDR" if country=="LaoPDR"
replace country="El Salvador" if country=="ElSalvador"
replace country="St. Kitts and Nevis" if country=="StKittsandNevis"
replace country="St. Lucia" if country=="StLucia"
replace country="St. Vincent and the Grenadines" if country=="StVincentandGrenadines"
replace country="Venezuela, RB" if country=="Venezuela"
replace country="South Sudan" if country=="Southsudan"

* Drop Luxembourg
drop if country=="Luxembourg"

* Merge with GDPxc (2017 international USD at PPP)
sort country year
merge country year using "dta/gdpxc2017.dta"
keep if _merge==3
drop _merge

* Select sample using current international USD at PPP
bys country: gen  tmp = 1 if gdpxc2017>=25000 & gdpxc2017!=.
bys country: egen tmp2 = sum(tmp)
keep if tmp2>0
keep if gdpxc2017!=.
rename gdpxc2017 gdpxc
gen log_gdpxc=log(gdpxc)


* Only formal firms
drop if b6a==2
drop if b6a<0

* Construct firm size
replace l1=. if l1<0
replace l1=. if l1>999990
gen log_l1=log(l1)


****************************************
* OBSERVATIONS IN LOCAL LABOR MARKET
bys a2x isic_v3_1 country year: egen obs=sum(wt_rs)

****************************************
* Merge with production data
sort idstd country year
merge idstd country year using "dta/Firm Level TFP Estimates and Factor Ratios_March_1_2024.dta"
keep if _merge==3
drop _merge
keep if sector_MS=="Manufacturing"


* Estimation of markdown by country
gen md=.
gen b_hat=.

levelsof CountryCode, local(countryid)
foreach c of local countryid{
 
qui: reghdfe log_d2 log_l1 c.log_n2e##c.log_n2e##c.log_n2e c.log_n7a##c.log_n7a##c.log_n7a  c.log_n7a#c.log_n2e [aw=wt_rs] if CountryCode== "`c'" , noabsorb

replace md=_b[log_l1]*exp(log_d2-log_n2a) if CountryCode== "`c'" 
replace b_hat=_b[log_l1] if CountryCode== "`c'" 

}

 
* Collapse at local labor market by country/year
preserve
collapse (median) md (mean) gdp obs [w=wt_rs], by(a2x isic_v3_1 country year)
qui:sum obs,d
gen totobs=r(sum)
gen shares=obs/totobs
collapse (median) md (mean) gdp  [w=shares], by(country year)


** MERGE WITH TFP
replace year=2019 if year>=2020
sort country year
merge country year using "dta/tfp.dta"
keep if _merge==3
drop _merge
 
gen log_gdp=log(gdp)
gen log_md=log(md)
gen log_ctfp = log(ctfp)
gen log_norm_tfp = log(norm_tfp)


reghdfe log_md log_ctfp,  noabsorb vce(r)
matrix b = e(b)
matrix x = e(V)
local slope_w  : di %4.3f b[1,1]
local se_slope_w  : di %4.3f (x[1,1])^0.5
local t_slope_w  : di %4.3f b[1,1]/((x[1,1])^0.5)


binscatter md ctfp,  line(lfit) lc(black)  ytitle("Median markdown",size(*1.5)) xtitle("Total Factor Productivity",size(*1.5)) ylabel(0(1)4)  xlabel(0.4(0.2)1.0)  caption("Slope (t-stat): `slope_w' (`t_slope_w')", color(maroon) position(150 0) size(*1.5)) savedata("out/median_markdown_tfp") replace
gr export "out/median_markdown_tfp.eps", replace



reghdfe log_md log_norm_tfp,  noabsorb vce(r)
matrix b = e(b)
matrix x = e(V)
local slope_w  : di %4.3f b[1,1]
local se_slope_w  : di %4.3f (x[1,1])^0.5
local t_slope_w  : di %4.3f b[1,1]/((x[1,1])^0.5)


binscatter md norm_tfp,  line(lfit) lc(black)  ytitle("Median markdown",size(*1.5)) xtitle("Total Factor Productivity",size(*1.5)) ylabel(0(1)4)  xlabel(0.4(0.2)1.2)  caption("Slope (t-stat): `slope_w' (`t_slope_w')", color(maroon) position(150 0) size(*1.5)) savedata("out/median_markdown_tfp_norm") replace
gr export "out/median_markdown_tfp_norm.eps", replace


* Store TFP
keep if (country=="Netherlands" || country=="Greece")
keep country year norm_tfp
export excel country year norm_tfp using "out/tfp_NET_GRE.xlsx", replace first(var)

restore


