*** DATA FROM: https://ec.europa.eu/eurostat/statistics-explained/index.php?title=Innovation_profiles_of_enterprises_-_results#How_innovative_are_European_businesses.3F


cls
clear
cd "/Users/tristany/Desktop/Replication_AJRR/Data/"


*** IMPORT EUROSTAT DATA ON INNOVATION
import excel "dta/inn_cis13_bas_ip__custom_17698651_page_spreadsheet.xlsx", sheet("Sheet 1") cellrange(A12:J47) firstrow
gen year=2022

destring Total, gen(totalfirm) force
gen innovative_share=Innovationactiveenterprises/totalfirm
gen investor_share= Entreprisesthathaveintroduced/totalfirm
gen rd_share=EnterpriseswithRDactivitie/totalfirm

rename INN_PFLabels country
replace country="Turkiye" if country=="Türkiye"
replace country="Slovak Republic" if country=="Slovakia"


* MERGE WITH GDP at 2017 constant price level
sort country year
merge country year using "dta/gdpxc2017.dta"
keep if _merge==3

* Drop Luxembourg
drop if country=="Luxembourg"
drop if country=="Ireland"

* Select sample using current international USD at PPP
bys country: gen  tmp = 1 if gdpxc2017>=25000 & gdpxc2017!=.
bys country: egen tmp2 = sum(tmp)
keep if tmp2>0
keep if gdpxc2017!=.
rename gdpxc2017 gdpxc
gen log_gdpxc=log(gdpxc)


*** COLLAPSE AT YEAR-COUNTRY LEVEL
collapse (mean) innovative_share investor_share rd_share gdp , by(country year)
gen log_gdp=log(gdp)


*** INNOVATIVE ACTIVE FIRMS
reghdfe innovative_share log_gdp, noabsorb vce(r)
matrix b = e(b)
matrix x = e(V)
local slope_w    : di %4.3f b[1,1]
local se_slope_w  : di %4.3f (x[1,1])^0.5
local t_slope_w  : di %4.3f b[1,1]/((x[1,1])^0.5)
binscatter innovative_share gdp, n(30)  line(lfit) lc(black)  ytitle("Innovative active firms",size(*1.5)) xtitle("GDP (2017 USD)",size(*1.5))   xlabel(20000(20000)80000) caption("Slope (t-stat): `slope_w' (`t_slope_w')", color(maroon) position(150 0) size(*1.5)) ylabel(0(0.2)1)  savedata("out/avg_innovactive_eurostat") replace
gr export "out/avg_innovactive_eurostat.eps", replace


*** FIRMS INTRODUCING INNOVATION
reghdfe investor_share log_gdp, noabsorb vce(r)
matrix b = e(b)
matrix x = e(V)
local slope_w    : di %4.3f b[1,1]
local se_slope_w  : di %4.3f (x[1,1])^0.5
local t_slope_w  : di %4.3f b[1,1]/((x[1,1])^0.5)
binscatter investor_share gdp, n(30)  line(lfit) lc(black)  ytitle("Firms introducing innovation",size(*1.5)) xtitle("GDP (2017 USD)",size(*1.5))   xlabel(20000(20000)80000) caption("Slope (t-stat): `slope_w' (`t_slope_w')", color(maroon) position(150 0) size(*1.5)) ylabel(0(0.2)1)  savedata("out/avg_innovation_eurostat") replace
gr export "out/avg_innovation_eurostat.eps", replace


*** FIRMS INTRODUCING R&D
reghdfe rd_share log_gdp, noabsorb vce(r)
matrix b = e(b)
matrix x = e(V)
local slope_w    : di %4.3f b[1,1]
local se_slope_w  : di %4.3f (x[1,1])^0.5
local t_slope_w  : di %4.3f b[1,1]/((x[1,1])^0.5)
binscatter rd_share gdp, n(30)  line(lfit) lc(black)  ytitle("Firms performing r&d",size(*1.5)) xtitle("GDP (2017 USD)",size(*1.5))   xlabel(20000(20000)80000) caption("Slope (t-stat): `slope_w' (`t_slope_w')", color(maroon) position(150 0) size(*1.5)) ylabel(0.0(0.10)0.6)  savedata("out/avg_rd_gdp_eurostat") replace
gr export "out/avg_rd_gdp_eurostat.eps", replace

 

